/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.Couple;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Carriage.class}, remap=false)
public class MixinCarriage
implements ICarriageConductors {
    private final List<UUID> controllingConductors = new ArrayList<UUID>();

    @Override
    public List<UUID> getControllingConductors() {
        return this.controllingConductors;
    }

    @Redirect(method={"updateConductors"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/trains/entity/CarriageContraptionEntity;checkConductors()Lcom/simibubi/create/foundation/utility/Couple;"))
    private Couple<Boolean> addControllingConductors(CarriageContraptionEntity instance) {
        this.controllingConductors.clear();
        Contraption contraption = instance.getContraption();
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            for (Entity passenger : instance.m_20197_()) {
                Couple validSides;
                BlockPos seatOf;
                if (!(passenger instanceof ConductorEntity) || (seatOf = cc.getSeatOf(passenger.m_142081_())) == null || (validSides = (Couple)cc.conductorSeats.get(seatOf)) == null || !((Boolean)validSides.getFirst()).booleanValue() && !((Boolean)validSides.getSecond()).booleanValue()) continue;
                this.controllingConductors.add(passenger.m_142081_());
            }
        }
        return instance.checkConductors();
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeControllingConductors(DimensionPalette dimensions, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        ListTag listTag = new ListTag();
        for (UUID uuid : this.controllingConductors) {
            CompoundTag uuidTag = new CompoundTag();
            uuidTag.m_128362_("UUID", uuid);
            listTag.add((Object)uuidTag);
        }
        tag.m_128365_("ControllingConductors", (Tag)listTag);
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void readControllingConductors(CompoundTag tag, TrackGraph graph, DimensionPalette dimensions, CallbackInfoReturnable<Carriage> cir) {
        Carriage carriage = (Carriage)cir.getReturnValue();
        List<UUID> controllingConductors = ((ICarriageConductors)carriage).getControllingConductors();
        controllingConductors.clear();
        if (tag.m_128425_("ControllingConductors", 9)) {
            ListTag listTag = tag.m_128437_("ControllingConductors", 10);
            for (Tag item : listTag) {
                CompoundTag uuidTag;
                if (!(item instanceof CompoundTag) || !(uuidTag = (CompoundTag)item).m_128403_("UUID")) continue;
                controllingConductors.add(uuidTag.m_128342_("UUID"));
            }
        }
    }
}

